#include <stdio.h>
#include <limits.h>

/*********************************
 * Prints the upper and lower 
 * bounds of numbers that can be
 * stored in the primitive data-
 * types for the current system.
 *
 * Author: Sarah Heckman, NCSU
 *********************************/
int main(void)
{
   //Chars: unsigned and signed
   printf("Unsigned chars: \n\tUCHAR_MIN = 0\n\tUCHAR_MAX = %u\n", UCHAR_MAX);
   printf("Signed chars: \n\tCHAR_MIN = %d\n\tCHAR_MAX = %d\n", CHAR_MIN, CHAR_MAX);

   //Shorts: unsigned and signed
   printf("Unsigned short: \n\tUSHRT_MIN = 0\n\tUSHRT_MAX = %u\n", USHRT_MAX);
   printf("Signed short: \n\tSHRT_MIN = %d\n\tSHRT_MAX = %d\n", SHRT_MIN, SHRT_MAX);

   //Ints: unsigned and signed
   printf("Unsigned int: \n\tUINT_MIN = 0\n\tUINT_MAX = %u\n", UINT_MAX);
   printf("Signed int: \n\tINT_MIN = %d\n\tINT_MAX = %d\n", INT_MIN, INT_MAX);

   //Longs: unsigned and signed
   printf("Unsigned long: \n\tULONG_MIN = 0\n\tULONG_MAX = %lu\n", ULONG_MAX);
   printf("Signed long: \n\tLONG_MIN = %ld\n\tLONG_MAX = %ld\n", LONG_MIN, LONG_MAX);

   //Long longs: unsigned and signed
   printf("Unsigned long long: \n\tULLONG_MIN = 0\n\tULLONG_MAX = %llu\n", ULLONG_MAX);
   printf("Signed long long: \n\tLLONG_MIN = %lld\n\tLLONG_MAX = %lld\n", LLONG_MIN, LLONG_MAX);

   return 0;
}
